#ifndef PARSER_ATP_SST_ROLLBACK_H
#define PARSER_ATP_SST_ROLLBACK_H


#include "msg_defs.h"
#include "SST_SEP_TST.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_SST_RollBack      
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application 
* of insertion, generation, reading, deletion, and usage of an AES symmetric key
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_RollBack (DxUint32_t* msg);
#endif
